/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.maintenance;

import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import jetbrains.exodus.backup.BackupStrategy;
import jetbrains.exodus.backup.VirtualFileDescriptor;
import jetbrains.exodus.util.IOUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FolderBackupStrategy
extends BackupStrategy {
    private static final String lockExtension = ".lck";
    protected static Log log = LogFactory.getLog(FolderBackupStrategy.class);
    private File location;
    private String treePrefix;

    public FolderBackupStrategy(File baseDirectory, String backupTreePrefix) {
        this.location = baseDirectory;
        this.treePrefix = backupTreePrefix;
    }

    public FolderBackupStrategy(File baseDirectory) {
        this(baseDirectory, "");
    }

    public void beforeBackup() throws Exception {
    }

    public void afterBackup() throws Exception {
    }

    public void onError(Throwable throwable) {
    }

    public Iterable<VirtualFileDescriptor> getContents() {
        return this.location.exists() ? new FolderIterable() : Collections.EMPTY_LIST;
    }

    public boolean canSkipInaccesibleFiles() {
        return false;
    }

    private class FolderIterable
    implements Iterable<VirtualFileDescriptor> {
        private FolderIterable() {
        }

        @Override
        public Iterator<VirtualFileDescriptor> iterator() {
            final LinkedList<BackupStrategy.FileDescriptor> queue = new LinkedList<BackupStrategy.FileDescriptor>();
            queue.add(new BackupStrategy.FileDescriptor(FolderBackupStrategy.this.location, FolderBackupStrategy.this.treePrefix));
            return new Iterator<VirtualFileDescriptor>(){
                private int i = 0;
                private int n = 0;
                private File[] files;
                private BackupStrategy.FileDescriptor nextPair;
                private String currentPrefix;

                @Override
                public boolean hasNext() {
                    if (this.nextPair != null) {
                        return true;
                    }
                    while (this.i < this.n) {
                        File file;
                        if (!(file = this.files[this.i++]).canRead()) {
                            String message = "Insufficient permissions to read " + file.getAbsolutePath();
                            if (FolderBackupStrategy.this.canSkipInaccesibleFiles()) {
                                if (!log.isWarnEnabled()) continue;
                                log.warn((Object)(message + ", skipping"));
                                continue;
                            }
                            throw new IllegalStateException(message);
                        }
                        String name = file.getName();
                        if (file.isDirectory() && !file.getName().equals("textindex")) {
                            queue.push(new BackupStrategy.FileDescriptor(file, this.currentPrefix + name + File.separator));
                            continue;
                        }
                        if (file.length() == 0L || name.endsWith(FolderBackupStrategy.lockExtension)) continue;
                        this.nextPair = new BackupStrategy.FileDescriptor(file, this.currentPrefix);
                        return true;
                    }
                    if (queue.isEmpty()) {
                        return false;
                    }
                    BackupStrategy.FileDescriptor pair = (BackupStrategy.FileDescriptor)queue.pop();
                    this.files = IOUtil.listFiles((File)pair.getFile());
                    this.currentPrefix = pair.getPath();
                    this.i = 0;
                    this.n = this.files.length;
                    this.nextPair = pair;
                    return true;
                }

                @Override
                public VirtualFileDescriptor next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    BackupStrategy.FileDescriptor result = this.nextPair;
                    this.nextPair = null;
                    return result;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

