/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistence.security;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import java.util.List;
import jetbrains.charisma.service.UserFilterService;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.SortByProperty;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.IterableUtils;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.youtrack.core.persistent.UserGroupImpl;

public class VisibilityGroupsProvider {
    public static String getVisibilityPresentation(Iterable<Entity> groups, Iterable<Entity> users) {
        String presentation = null;
        int count = 0;
        for (Entity entity : Sequence.fromIterable((Iterable)QueryOperations.concat((Iterable)QueryOperations.query(groups, (String)"UserGroup", (NodeBase)new SortByProperty(null, "name", true)), (Iterable)QueryOperations.query(users, (String)"User", (NodeBase)new SortByProperty(null, "login", true))))) {
            if (presentation == null) {
                presentation = VisibilityGroupsProvider.getElementPresentation(entity);
                continue;
            }
            ++count;
        }
        if (presentation == null) {
            return UserGroupImpl.getAllUsersGroupNameInLocale();
        }
        if (count == 0) {
            return presentation;
        }
        return presentation + " +" + count;
    }

    public static String getFullVisibilityPresentation(Iterable<Entity> groups, Iterable<Entity> users) {
        return IterableUtils.join((Iterable)ListSequence.fromList(VisibilityGroupsProvider.getVisibilityPresentationTitles(groups, users)), (String)", ");
    }

    public static List<String> getVisibilityPresentationTitles(Iterable<Entity> groups, Iterable<Entity> users) {
        IListSequence result = Sequence.fromIterable((Iterable)QueryOperations.query(groups, (String)"UserGroup", (NodeBase)new SortByProperty(null, "name", true))).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, String>(){

            public String select(Entity it) {
                return (String)PrimitiveAssociationSemantics.get((Entity)it, (String)"name", String.class, (Object)UserGroupImpl.getAllUsersGroupNameInLocale());
            }
        }).concat(Sequence.fromIterable((Iterable)QueryOperations.query(users, (String)"User", (NodeBase)new SortByProperty(null, "login", true))).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, String>(){

            public String select(Entity it) {
                return (String)PrimitiveAssociationSemantics.get((Entity)it, (String)"fullName", String.class, null) + " (" + (String)PrimitiveAssociationSemantics.get((Entity)it, (String)"login", String.class, (Object)"<no user>") + ")";
            }
        })).toListSequence();
        if (result.size() == 0) {
            ListSequence.fromList((List)result).addElement((Object)UserGroupImpl.getAllUsersGroupNameInLocale());
        }
        return result;
    }

    public static String getElementPresentation(Entity userOrGroup) {
        if ("UserGroup".equals(userOrGroup.getType())) {
            return (String)((Object)userOrGroup.getProperty("name"));
        }
        return UserFilterService.RenderStyle.ME_VISIBLE_NAME.render(userOrGroup);
    }
}

