/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistent;

import java.io.File;
import jetbrains.charisma.main.ConfigurationUtil;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.exodus.entitystore.PersistentEntityStoreStatistics;
import jetbrains.exodus.env.EnvironmentStatistics;
import jetbrains.exodus.util.IOUtil;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeArithmetics;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.application.DatabaseSettingsFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.Duration;

public class DiskSpaceManagement {
    protected static Log log = LogFactory.getLog(DiskSpaceManagement.class);
    private volatile long storageSize = 0L;
    private volatile long backupSize = 0L;
    private volatile boolean onceInvalidated = false;

    public long getStorageSizeWithBackups() {
        return this.getStorageSize() + this.backupSize;
    }

    public long getStorageSize() {
        long result = this.storageSize;
        if (this.onceInvalidated) {
            result += this.blobsDiskSpace();
        }
        return result;
    }

    public void invalidateIfRequired() {
        if (!this.onceInvalidated) {
            this.invalidate();
        }
    }

    public void invalidate() {
        File dir;
        String backupLocation;
        Long started = System.currentTimeMillis();
        PersistentEntityStore store = (PersistentEntityStore)ServiceLocator.getBean((String)"persistentEntityStore");
        this.storageSize = ((PersistentEntityStore)ServiceLocator.getBean((String)"persistentEntityStore")).getEnvironment().getStatistics().getStatisticsItem((Enum)EnvironmentStatistics.Type.DISK_USAGE).getTotal();
        long backupSize = 0L;
        if (!ConfigurationUtil.isYoutrackHosted() && (backupLocation = ((DatabaseSettingsFactory)ServiceLocator.getBean((String)"databaseSettingsFactory")).resolveBackupLocation()) != null && backupLocation.length() > 0 && (dir = new File(backupLocation)).exists() && dir.isDirectory()) {
            backupSize = IOUtil.getDirectorySize((File)dir, (String)"", (boolean)false);
        }
        this.backupSize = backupSize;
        this.blobsDiskSpace();
        this.onceInvalidated = true;
        Long duration = DateTimeOperations.convert((Duration)DateTimeArithmetics.minus((Long)System.currentTimeMillis(), (Long)started));
        if (duration > 1000L && log.isWarnEnabled()) {
            log.warn((Object)("Occupied disk space calculated for '" + store.getLocation() + "' in " + duration + "ms: [" + this.storageSize + "]"));
        }
    }

    private long blobsDiskSpace() {
        return ((PersistentEntityStore)ServiceLocator.getBean((String)"persistentEntityStore")).getStatistics().getStatisticsItem((Enum)PersistentEntityStoreStatistics.Type.BLOBS_DISK_USAGE).getTotal();
    }
}

