/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistent;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.Transaction;
import jetbrains.springframework.configuration.runtime.ServiceLocator;

public class GcTransaction {
    private final AtomicReference<MyThread> thread = new AtomicReference();

    public boolean start() {
        MyThread t;
        if (this.thread.get() == null && this.thread.compareAndSet(null, t = new MyThread(((PersistentEntityStore)ServiceLocator.getBean((String)"persistentEntityStore")).getEnvironment(), new Semaphore(0)))) {
            t.start();
            return true;
        }
        return false;
    }

    public boolean stop() {
        MyThread t = this.thread.get();
        if (t != null && this.thread.compareAndSet(t, null)) {
            t.sema.release();
            return true;
        }
        return false;
    }

    private static class MyThread
    extends Thread {
        private final Semaphore sema;

        private MyThread(final Environment environment, final Semaphore sema) {
            super(new Runnable(){

                @Override
                public void run() {
                    Transaction txn = environment.beginTransaction();
                    try {
                        sema.acquire();
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        ie.printStackTrace();
                    }
                    finally {
                        txn.abort();
                    }
                }
            }, "Thread with transaction preventing files from being deleted");
            this.sema = sema;
        }
    }
}

