/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistent;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.UndirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import com.jetbrains.teamsys.dnq.database.IncomingLinkViolation;
import com.jetbrains.teamsys.dnq.database.MessageBuilder;
import java.io.InputStream;
import java.util.Collection;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistent.Base64Attach;
import jetbrains.charisma.persistent.BaseAttachmentImpl;
import jetbrains.charisma.persistent.ConstraintsErrorMessageUtil;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.NodeBase;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.security.IssueSecurityService;
import jetbrains.youtrack.core.persistent.UserImpl;
import jetbrains.youtrack.core.security.Operation;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;

public class IssueAttachmentImpl
extends BaseAttachmentImpl {
    private static String __ENTITY_TYPE__ = "IssueAttachment";

    @Override
    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    public IncomingLinkViolation createIncomingLinkViolation(String name) {
        String linkName = name;
        if ("author".equals(linkName)) {
            return new IncomingLinkViolation(linkName){

                public Collection<String> getDescription() {
                    return this.createPerTypeErrorMessage(new MessageBuilder(){

                        public String build(Iterable<Entity> linkedEntities, Entity entity, boolean hasMore) {
                            return ConstraintsErrorMessageUtil.createReportAboutAttachments(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("IssueAttachment.author_of_attachments_in", new Object[0]), linkedEntities, hasMore);
                        }
                    });
                }
            };
        }
        return new IncomingLinkViolation(linkName);
    }

    @NotNull
    public Long getUpdated(Entity entity) {
        Long result;
        Long updated = (Long)PrimitiveAssociationSemantics.get((Entity)entity, (String)"updated", null);
        Long l = result = updated == null ? (Long)PrimitiveAssociationSemantics.get((Entity)entity, (String)"created", null) : updated;
        if (result == null) {
            return 0L;
        }
        return result;
    }

    public void setDraft(boolean isDraft, Entity entity) {
        if (isDraft) {
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"draft", (Comparable)Boolean.valueOf(true), Boolean.class);
        } else {
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"draft", null);
        }
    }

    public void setPermittedGroup(Entity group, Entity entity) {
        UndirectedAssociationSemantics.clearManyToMany((Entity)entity, (String)"permittedGroup", (String)"securedAttachments");
        UndirectedAssociationSemantics.clearManyToMany((Entity)entity, (String)"permittedUser", (String)"visibleAttachments");
        if (!EntityOperations.equals((Entity)group, null) && !((Boolean)PrimitiveAssociationSemantics.get((Entity)group, (String)"allUsersGroup", Boolean.class, null)).booleanValue()) {
            UndirectedAssociationSemantics.createManyToMany((Entity)entity, (String)"permittedGroup", (String)"securedAttachments", (Entity)group);
        }
    }

    public void setPermitted(Iterable<Entity> groups, Iterable<Entity> users, final Entity entity) {
        UndirectedAssociationSemantics.clearManyToMany((Entity)entity, (String)"permittedGroup", (String)"securedAttachments");
        UndirectedAssociationSemantics.clearManyToMany((Entity)entity, (String)"permittedUser", (String)"visibleAttachments");
        Sequence.fromIterable(groups).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity __addallit__) {
                UndirectedAssociationSemantics.createManyToMany((Entity)entity, (String)"permittedGroup", (String)"securedAttachments", (Entity)__addallit__);
            }
        });
        Sequence.fromIterable(users).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity __addallit__) {
                UndirectedAssociationSemantics.createManyToMany((Entity)entity, (String)"permittedUser", (String)"visibleAttachments", (Entity)__addallit__);
            }
        });
    }

    public boolean isSecured(Entity entity) {
        return !QueryOperations.isEmpty((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"permittedGroup")) || !QueryOperations.isEmpty((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"permittedUser"));
    }

    public void updateFromBase64(Base64Attach base64, Entity entity) {
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"size", (Comparable)Long.valueOf(base64.getSize()), Long.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"mimeType", (Comparable)((Object)base64.getMimeType()), String.class);
        PrimitiveAssociationSemantics.setBlob((Entity)entity, (String)"content", (InputStream)base64.getContent());
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"metaData", null, String.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"charset", (Comparable)((Object)"UTF-8"), String.class);
        String newExtension = FilenameUtils.getExtension((String)((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"mimeType", String.class, null)).replaceAll("/", "."));
        if (newExtension != null && newExtension.length() > 0) {
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"extension", (Comparable)((Object)newExtension), String.class);
        }
        if (this.isImage(entity)) {
            for (Entity item : Sequence.fromIterable((Iterable)QueryOperations.query(null, (String)"AttachmentThumbnail", (NodeBase)new LinkEqual("imageFile", entity)))) {
                EntityOperations.remove((Entity)item);
            }
        }
    }

    public static boolean canCreateAttachment(Entity issue) {
        return IssueAttachmentImpl.canCreateAttachment(issue, ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get());
    }

    public static boolean canCreateAttachment(Entity issue, Entity user) {
        if (EntityOperations.equals((Entity)issue, null) || ((IssueSecurityService)ServiceLocator.getBean((String)"issueSecurityService")).isAccessible(issue, Operation.READ, user)) {
            return ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).hasPermission("IssueAttachment", Operation.CREATE, AssociationSemantics.getToOne((Entity)issue, (String)"project"), user);
        }
        return false;
    }

    public static void moveAttachments(final Entity source, final Entity target) {
        Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)source, (String)"attachments")).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity it) {
                DirectedAssociationSemantics.removeToMany((Entity)source, (String)"attachments", (Entity)it);
                DirectedAssociationSemantics.createToMany((Entity)target, (String)"attachments", (Entity)it);
                DirectedAssociationSemantics.setToOne((Entity)it, (String)"issue", (Entity)target);
            }
        });
    }
}

