/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.dto;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.plugins.GeneralUserProfile;
import jetbrains.charisma.service.UserProfileService;
import jetbrains.charisma.smartui.watchFolder.StarService;
import jetbrains.exodus.core.dataStructures.hash.HashMap;
import jetbrains.exodus.core.dataStructures.hash.LongHashMap;
import jetbrains.exodus.core.dataStructures.hash.LongHashSet;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.util.StringHashMap;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.persistent.IssueImpl;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTimeZone;
import webr.framework.controller.BaseApplication;

public class IssueRequestDataHolder {
    private static String NAME = IssueRequestDataHolder.class.getName();
    private LongHashMap<Object> duplicateClustersUnflushed = new LongHashMap();
    private LongHashSet votesRecounted = new LongHashSet();
    private StringHashMap<Entity> projectCustomFields = new StringHashMap();
    private Map<Entity, Entity> watchFoldersToWatchRules = null;
    private Entity star;
    public boolean disabled;
    private Entity myMe;
    private DateTimeZone myMyTimeZone;
    private Locale myMyLocale;
    private String myDateFieldFormat;

    private IssueRequestDataHolder() {
        this.setMe(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get());
        GeneralUserProfile userProfile = ((UserProfileService)ServiceLocator.getBean((String)"userProfileService")).getGeneralUserProfile(this.getMe());
        this.setMyTimeZone(userProfile.getTimeZone());
        this.setDateFieldFormat(userProfile.getDateFieldFormat());
        this.setMyLocale(userProfile.getLocale());
    }

    @Nullable
    public Object getDuplicateClusterUnflushed(Entity root) {
        return this.duplicateClustersUnflushed.get(((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)root, (String)"Issue")).getPersistentLocalId(root));
    }

    public void setDuplicateClusterUnflushed(Entity root, Object cluster) {
        this.duplicateClustersUnflushed.put(((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)root, (String)"Issue")).getPersistentLocalId(root), cluster);
    }

    public boolean areVotesRecountedFor(Entity issue) {
        return this.votesRecounted.contains(((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getPersistentLocalId(issue));
    }

    public void votesRecountedFor(Entity issue) {
        this.votesRecounted.add(((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getPersistentLocalId(issue));
    }

    public void setProjectCustomField(@Nullable Entity p, String name, @Nullable Entity pcf) {
        if (!EntityOperations.equals((Entity)p, null)) {
            this.projectCustomFields.put(p.getId().toString() + '#' + name, (Object)pcf);
        }
    }

    public boolean hasProjectCustomField(@Nullable Entity p, String name) {
        return !EntityOperations.equals((Entity)p, null) && this.projectCustomFields.containsKey((Object)(p.getId().toString() + '#' + name));
    }

    @Nullable
    public Entity getProjectCustomField(@Nullable Entity p, String name) {
        if (EntityOperations.equals((Entity)p, null)) {
            return null;
        }
        String id = p.getId().toString() + '#' + name;
        Entity field = (Entity)this.projectCustomFields.get((Object)id);
        if (EntityOperations.isRemoved((Entity)field)) {
            this.projectCustomFields.remove((Object)id);
            return null;
        }
        return field;
    }

    public boolean watchRulesInited() {
        return this.watchFoldersToWatchRules != null;
    }

    public void initWatchRules() {
        this.watchFoldersToWatchRules = new HashMap();
    }

    public void setWatchRuleByWatchFolder(Entity rule) {
        this.watchFoldersToWatchRules.put(AssociationSemantics.getToOne((Entity)rule, (String)"watchFolder"), rule);
    }

    public Entity getWatchRuleByWatchFolder(Entity folder) {
        return this.watchFoldersToWatchRules.get(folder);
    }

    public Entity getStar() {
        if (this.star == null) {
            this.star = ((StarService)ServiceLocator.getBean((String)"starService")).findStar(this.getMe());
        }
        return this.star;
    }

    public Entity getMe() {
        return this.myMe;
    }

    private void setMe(Entity value) {
        this.myMe = value;
    }

    public DateTimeZone getMyTimeZone() {
        return this.myMyTimeZone;
    }

    private void setMyTimeZone(DateTimeZone value) {
        this.myMyTimeZone = value;
    }

    public Locale getMyLocale() {
        return this.myMyLocale;
    }

    private void setMyLocale(Locale value) {
        this.myMyLocale = value;
    }

    public String getDateFieldFormat() {
        return this.myDateFieldFormat;
    }

    private void setDateFieldFormat(String value) {
        this.myDateFieldFormat = value;
    }

    @Nullable
    public static IssueRequestDataHolder get() {
        if (!BaseApplication.isInsideRequestProcessing()) {
            return null;
        }
        HttpServletRequest req = BaseApplication.getRequest();
        IssueRequestDataHolder dto = (IssueRequestDataHolder)req.getAttribute(NAME);
        if (dto == null) {
            dto = new IssueRequestDataHolder();
            req.setAttribute(NAME, (Object)dto);
        }
        return dto;
    }

    public static IssueRequestDataHolder getDontCreate() {
        if (!BaseApplication.isInsideRequestProcessing()) {
            return null;
        }
        IssueRequestDataHolder result = (IssueRequestDataHolder)BaseApplication.getRequest().getAttribute(NAME);
        if (result != null && result.disabled) {
            return null;
        }
        return result;
    }
}

