/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.event;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.common.event.EventListener;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBus {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventBus.class);
    private final Map<Class, List<EventListener>> allEventListeners = new ConcurrentHashMapEx<Class, List<EventListener>>();
    private static final EventBus INSTANCE = new EventBus();

    public static EventBus getInstance() {
        return INSTANCE;
    }

    private EventBus() {
        List<EventListener> listeners = SPIServiceUtils.getAllService(EventListener.class);
        for (EventListener listener : listeners) {
            this.registerEventListener(listener);
            LOGGER.info("EventBus register " + listener.getClass().getName() + " for process " + listener.getEventClass().getName());
        }
    }

    public void registerEventListener(EventListener eventListener) {
        List eventListeners = this.allEventListeners.computeIfAbsent(eventListener.getEventClass(), f -> new CopyOnWriteArrayList());
        eventListeners.add(eventListener);
    }

    public void unregisterEventListener(EventListener eventListener) {
        List eventListeners = this.allEventListeners.computeIfAbsent(eventListener.getEventClass(), f -> new CopyOnWriteArrayList());
        if (eventListeners.contains(eventListener)) {
            eventListeners.remove(eventListener);
        }
    }

    public void triggerEvent(Object event) {
        List eventListeners = this.allEventListeners.getOrDefault(event.getClass(), Collections.emptyList());
        for (EventListener eventListener : eventListeners) {
            eventListener.process(event);
        }
    }
}

